<?php
/**
 * Plugin Name: Reportar Comentarios
 * Plugin URI: http://www.kanet.cl
 * Description: Este plugin modifica los títulos de las entradas.
 * Version: 1.0.0
 * Author: David Aguilera
 * Author URI: http://www.kanet.cl
 * Requires at least: 4.0
 * Tested up to: 4.3
 *
 * Text Domain: reportar-comentario
 */

 function myplugin_comment_columns( $columns )
 {
 	return array_merge( $columns, array(
 		'reportes' => __( 'Reportado' ),
    'usuarios_reportes' => __( 'Usuarios Reporte' )
 	) );
 }
 add_filter( 'manage_edit-comments_columns', 'myplugin_comment_columns' );

 function myplugin_comment_column( $column, $comment_ID )
 {

   switch ( $column ) {
   		case 'usuarios_reportes':
        $meta = get_comment_meta( $comment_ID, $column , false );
        echo $meta[0];
      break;
   		case 'reportes':
        $meta = get_comment_meta( $comment_ID, $column , false );
        if( $meta[0] != "") {
          if($meta[0] == "1") {echo $meta[0].' Vez<br /><br /><a href="'.plugins_url().'/reportar/reportar_reset.php?id='.$comment_ID.'">Resetear</a>'; }
          else {
            echo $meta[0].' Veces<br /><br /><a href="'.plugins_url().'/reportar/reportar_reset.php?id='.$comment_ID.'">Resetear</a>';
          }
        }
        else {
          echo '-';
        }
   		break;
   	}
 	}




 add_filter( 'manage_comments_custom_column', 'myplugin_comment_column', 10, 2 );


 function my_sortable_myplugin_comment_colum( $columns ) {
     $columns['reportes'] = 'reportes';
    
     //To make a column 'un-sortable' remove it from the array
     //unset($columns['date']);

     return $columns;
 }

 add_filter("manage_edit-comments_sortable_columns","my_sortable_myplugin_comment_colum" );


 function crea_campo_reporte( $comment_id) {
    add_comment_meta( $comment_id, 'reportes', '0', false );
    add_comment_meta( $comment_id, 'usuarios_reportes', '-', false );
 }
 add_action( 'comment_post', 'crea_campo_reporte' );


 function reportar($id_comment, $id_user){
   $actual = get_comment_meta( $id_comment, 'reportes' , false );
   $actual_users = get_comment_meta( $id_comment, 'usuarios_reportes' , false );

   $nuevo = $actual[0] + 1;

   $pos = strpos($actual_users[0], '|');
   $user_exist = false;

  if ($pos === false) {

     if($id_user == $actual_users[0]) {
       $user_exist = true;
       $respuesta = '1';
     }
     else{
       if( $actual_users[0] == '-') {
         $nuevo_user = $id_user;
        }
        else { $nuevo_user = $actual_users[0].'|'.$id_user;}
     }
   }
   else {
       $usuarios =  explode("|", $actual_users[0]);
       foreach ($usuarios as &$valor) {
         if($id_user == "$valor") {
           $user_exist = true;
           $respuesta = '1';
         }
       }
       $nuevo_user = $actual_users[0].'|'.$id_user;
     }



if($respuesta != '1'){
   if(
     update_comment_meta( $id_comment, 'reportes', $nuevo )  &&
     update_comment_meta( $id_comment, 'usuarios_reportes', $nuevo_user )
     )
   {

     $reportes_num = get_field('reportes_permitidos', 'muse_config');
     if($nuevo >= $reportes_num ){
          wp_set_comment_status( $id_comment, 'hold' );
        }
     $respuesta = '0';
   }
   else { $respuesta = '2';

 }

     }

     return $respuesta;
   }



?>
