# S214 Settings Library
[![Travis](https://img.shields.io/travis/Section214/S214-Settings-Demo.svg?maxAge=2592000)](https://travis-ci.org/Section214/S214-Settings-Demo/)
[![Scrutinizer Code Quality](https://scrutinizer-ci.com/g/Section214/S214-Settings-Demo/badges/quality-score.png?b=master)](https://scrutinizer-ci.com/g/Section214/S214-Settings-Demo/?branch=master)
[![Code Coverage](https://scrutinizer-ci.com/g/Section214/S214-Settings-Demo/badges/coverage.png?b=master)](https://scrutinizer-ci.com/g/Section214/S214-Settings-Demo/?branch=master)
[![License](https://img.shields.io/badge/license-GPL--2.0%2B-green.svg)](https://github.com/Section214/S214-Settings/blob/master/license.txt)

[![Packagist](https://img.shields.io/packagist/v/Section214/S214-Settings.svg?maxAge=2592000)]()
[![Packagist Pre Release](https://img.shields.io/packagist/vpre/Section214/S214-Settings.svg?maxAge=2592000)]()


## What Is This?

Depending on the size of a project, you may be able to get away with adding settings to an existing WordPress page (or the customizer). On the other end of the spectrum, you may need (or want) to implement a full-scale control panel like [Redux](http://reduxframework.com). But what if your project is somewhere in the middle? Or what if you need a control panel, but don't want the bulk that goes along with most? This is an issue that I've struggled with for some time. My standard implementation has historically been a fork of the awesome system used by [Easy Digital Downloads](http://section214.com/go/easy-digital-downloads). However, this has its own set of issues. For each project, I had to sort through the various required files and update function and variable names to prevent conflicts, and the process of implementing it was arduous. Thus, I finally sat down and converted it into a reusable library which I am now sharing with the general public! Read on to check out the basic implementation.

More information can be found on the [wiki](https://github.com/Section214/S214-Settings/wiki).

## Installation

1. You can clone the GitHub repository: `https://github.com/Section214/S214-Settings.git`
2. Or download it directly as a ZIP file: `https://github.com/Section214/S214-Settings/archive/master.zip`

This will download the latest developer copy of the S214 Settings library.

## Bugs

If you find an issue, let us know [here](https://github.com/Section214/S214-Settings/issues?state=open)!

## Contributions

Anyone is welcome to contribute to the library. Please read the [guidelines for contributing](https://github.com/Section214/S214-Settings/blob/master/CONTRIBUTING.md) to this repository.

There are various ways you can contribute:

1. Raise an [Issue](https://github.com/Section214/S214-Settings/issues) on GitHub
2. Send us a Pull Request with your bug fixes and/or new features
3. Provide feedback and suggestions on [enhancements](https://github.com/Section214/S214-Settings/issues?direction=desc&labels=Enhancement&page=1&sort=created&state=open)
